#include <bits/stdc++.h>
using namespace std;


class DisjointSet {
	public:
		vector<int> pointer, rank;
		DisjointSet(int V) {
			pointer.resize(V);
			rank.resize(V);
			for (int i=0;i<V;i++) pointer[i]=i, rank[i]=0;
		}
		int query(int T) {
			if (pointer[T]==T) return T;
			return (pointer[T]=query(pointer[T]));
		}
		void merge(int u, int v) {
			/*
			if (rank[u]==rank[v]) pointer[v]=u, rank[u]++;
			else if (rank[u]>rank[v]) pointer[v]=u;
			else pointer[u]=v;
			*/
			pointer[query(u)] = query(v);
		}
};

struct Edge {
	int u, v, w;
};

bool cmp(Edge a, Edge b) {
	return a.w < b.w;
}

int main() {
	int V, E, w1=0;cin >> V >> E;
	DisjointSet djs(V);
	Edge Es[E];
	for (int i=0;i<E;i++) {
		int u, v, w;cin >> u >> v >> w;
		u--;v--;
		Es[i] = {u, v, w};
	}
	sort(Es, Es+E, cmp);
	for (int i=0;i<E;i++) {
		if (djs.query(Es[i].u)==djs.query(Es[i].v)) w1 += Es[i].w;
		else djs.merge(Es[i].u, Es[i].v);
	}
	cout << w1;
	return 0;
}

