#include <bits/stdc++.h>
using namespace std;
typedef vector<long long> V1D;
typedef vector<V1D> V2D;


class Matrix {
    private:
        V2D value;
        long long MH, MW;
    public :
        // Matrix() {}
        Matrix(V2D Vec) {value=Vec;MH=Vec.size(), MW=Vec[0].size();}
        Matrix(long long H, long long W) {
            MH=H, MW=W;
            for (long long i=0;i<H;i++) value.push_back(V1D(W));
        }
        long long getHeight() {return MH;}
        long long getWidth() {return MW;}
        long long getValue(long long y, long long x) {return value[y][x];}
        void change(long long y, long long x, long long v) {value[y][x] = v;}
        V2D matrixVec() {return value;}
        Matrix operator+(Matrix Mx) {
            long long Hx=Mx.getHeight(), Wx=Mx.getWidth();
            if (Hx != MH || Wx != MW) {
                cout << "Matrix Exception (operator+, E1) : Size not equal.";
                exit(0);
            }
            Matrix Mr(MH, MW);
            for (long long i=0;i<MH;i++) {
                for (long long j=0;j<MW;j++) Mr.change(i, j, value[i][j]+Mx.getValue(i, j));
            }
            return Mr;
        }
        Matrix operator-(Matrix Mx) {
            long long Hx=Mx.getHeight(), Wx=Mx.getWidth();
            if (Hx != MH || Wx != MW) {
                cout << "Matrix Exception (operator-, E2) : Size not equal.";
                exit(0);
            }
            Matrix Mr(MH, MW);
            for (long long i=0;i<MH;i++) {
                for (long long j=0;j<MW;j++) Mr.change(i, j, value[i][j]-Mx.getValue(i, j));
            }
            return Mr;
        }
        Matrix operator*(Matrix Mx) {
            long long Hx=Mx.getHeight(), Wx=Mx.getWidth();
            if (MW!=Hx) {
                cout << "Matrix Exception (operator*, E3) : Illegal H/W.";
                exit(0);
            }
            Matrix Mr(MH, Wx);
            for (long long i=0;i<MH;i++) {
                for (long long j=0;j<Wx;j++) {
                    long long cur=0;
                    for (long long k=0;k<MW;k++) cur += value[i][k] * Mx.getValue(k, j);
                    Mr.change(i, j, cur);
                }
            }
            return Mr;
        }
        Matrix operator%(long long MOD) {
            Matrix Mr(value);
            for (long long i=0;i<MH;i++) {
                for (long long j=0;j<MW;j++) Mr.change(i, j, Mr.getValue(i, j)%MOD);
            }
            return Mr;
        }
};

Matrix UnitMatrix(long long K) {
    Matrix M0(K, K);
    for (long long i=0;i<K;i++) M0.change(i, i, 1);
    return M0;
};

Matrix qkMpow(Matrix Mx, long long e, long long MOD) {
    long long K = Mx.getHeight();
    if (e==0) return UnitMatrix(K);
    if (e==1) return Mx;
    Matrix HF = qkMpow(Mx, e/2, MOD);
    if (e&1) return ((HF*HF)*Mx)%MOD;
    return (HF*HF)%MOD;
};

int main() {
    freopen("fibonacci.in","r",stdin);
    freopen("fibonacci.out","w",stdout);
    long long N, MOD;cin >> N >> MOD;
    Matrix M0(2, 2);
    M0.change(0, 1, 1);
    M0.change(1, 0, 1);
    M0.change(1, 1, 1);
    Matrix M = qkMpow(M0, N, MOD);
    V2D Vec = M.matrixVec();
    for (long long i=0;i<2;i++) {
        for (long long j=0;j<2;j++) cout << Vec[i][j] << ' ';
        cout << endl;
    }
    
    return 0;
}
